/*
 * Decompiled with CFR 0.152.
 */
package me.angel.challenges6t4.challenge;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import me.angel.challenges6t4.challenge.Challenge;
import me.angel.challenges6t4.network.ChallengeNetworking;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class ChallengeRegistry {
    private static final Map<String, Challenge> CHALLENGES = new HashMap<String, Challenge>();
    private static MinecraftServer currentServer = null;
    private static boolean serverFullyInitialized = false;

    public static void register(Challenge challenge) {
        CHALLENGES.put(challenge.getId(), challenge);
    }

    public static Challenge getChallenge(String id) {
        return CHALLENGES.get(id);
    }

    public static Collection<Challenge> getAllChallenges() {
        return CHALLENGES.values();
    }

    public static boolean isAnyEnabled() {
        return CHALLENGES.values().stream().anyMatch(Challenge::isEnabled);
    }

    public static boolean areAllBeatable() {
        return CHALLENGES.values().stream().filter(Challenge::isEnabled).allMatch(challenge -> !challenge.isTrueMode() && challenge.isGameBeatable());
    }

    public static void clear() {
        CHALLENGES.clear();
    }

    public static void setServer(MinecraftServer server) {
        currentServer = server;
        serverFullyInitialized = false;
    }

    public static void setServerFullyInitialized() {
        serverFullyInitialized = true;
    }

    public static void syncToAllClients() {
        if (!serverFullyInitialized) {
            System.out.println("Server not fully initialized yet - skipping challenge sync");
            return;
        }
        if (currentServer != null && currentServer.method_3760() != null && !currentServer.method_3760().method_14571().isEmpty()) {
            class_3222 firstPlayer = (class_3222)currentServer.method_3760().method_14571().get(0);
            ChallengeNetworking.sendToAllClients(firstPlayer);
            System.out.println("Synced challenge states to " + currentServer.method_3760().method_14571().size() + " clients");
        } else if (currentServer != null && currentServer.method_3760() != null) {
            System.out.println("Challenge states changed - will sync when players join");
        } else {
            System.out.println("No server or player manager available for challenge sync");
        }
    }

    public static void syncToAllClientsFromServer(class_3222 referencePlayer) {
        if (referencePlayer != null) {
            ChallengeNetworking.sendToAllClients(referencePlayer);
        } else {
            ChallengeRegistry.syncToAllClients();
        }
    }

    public static void syncToClient(class_3222 player) {
        ChallengeNetworking.sendToClient(player);
    }
}

